# 📦 Guia de Instalação - Sistema de Pessoas Desaparecidas

## Pré-requisitos

- **PHP 7.4 ou superior** (com suporte a SQLite)
- **Servidor Web** (Apache, Nginx ou PHP Built-in)
- **Navegador moderno** (Chrome, Firefox, Safari, Edge)

## 🚀 Instalação Rápida

### 1. Extrair o Projeto

```bash
tar -xzf pessoas-desaparecidas.tar.gz
cd pessoas-desaparecidas
```

### 2. Criar Pasta de Imagens

```bash
mkdir -p assets/images
chmod 755 assets/images
```

### 3. Iniciar o Servidor PHP (Desenvolvimento)

```bash
php -S localhost:8000 -t public/
```

### 4. Acessar no Navegador

- **Página Pública:** http://localhost:8000/
- **Admin:** http://localhost:8000/../admin/login.php

## 🔐 Credenciais Padrão

| Campo | Valor |
|-------|-------|
| Usuário | `admin` |
| Senha | `admin123` |

⚠️ **IMPORTANTE:** Altere a senha padrão após o primeiro acesso!

## 🔧 Instalação em Produção

### Apache

1. **Copiar arquivos para o DocumentRoot:**
   ```bash
   cp -r pessoas-desaparecidas /var/www/html/
   ```

2. **Configurar permissões:**
   ```bash
   chmod -R 755 /var/www/html/pessoas-desaparecidas
   chmod -R 777 /var/www/html/pessoas-desaparecidas/assets/images
   chmod -R 777 /var/www/html/pessoas-desaparecidas/database
   ```

3. **Ativar mod_rewrite (se necessário):**
   ```bash
   sudo a2enmod rewrite
   sudo systemctl restart apache2
   ```

### Nginx

1. **Copiar arquivos:**
   ```bash
   cp -r pessoas-desaparecidas /var/www/html/
   ```

2. **Usar configuração fornecida:**
   ```bash
   sudo cp pessoas-desaparecidas/nginx.conf /etc/nginx/sites-available/pessoas-desaparecidas
   sudo ln -s /etc/nginx/sites-available/pessoas-desaparecidas /etc/nginx/sites-enabled/
   sudo systemctl restart nginx
   ```

3. **Configurar PHP-FPM:**
   ```bash
   sudo systemctl start php8.1-fpm
   ```

## 📁 Estrutura de Diretórios

```
pessoas-desaparecidas/
├── public/
│   └── index.php              # Página pública
├── admin/
│   ├── login.php              # Login
│   ├── index.php              # Dashboard
│   ├── pessoas.php            # Gerenciar pessoas
│   ├── contatos.php           # Ver contatos
│   └── logout.php             # Logout
├── includes/
│   ├── config.php             # Configuração BD
│   ├── auth.php               # Autenticação
│   └── functions.php          # Funções
├── assets/
│   └── images/                # Fotos (criada automaticamente)
├── database/
│   └── pessoas_desaparecidas.db  # BD SQLite (criado automaticamente)
├── README.md                  # Documentação
├── INSTALACAO.md              # Este arquivo
├── .htaccess                  # Reescrita URLs (Apache)
├── nginx.conf                 # Config Nginx
└── test.php                   # Script de teste
```

## 🔄 Primeiro Acesso

### 1. Acessar Admin
- URL: `http://seu-dominio/admin/login.php`
- Usuário: `admin`
- Senha: `admin123`

### 2. Alterar Senha do Admin

Para alterar a senha padrão, execute este comando PHP:

```php
<?php
require_once 'includes/config.php';
$db = getDB();
$new_password = password_hash('sua_nova_senha', PASSWORD_BCRYPT);
$db->prepare('UPDATE admins SET password = ? WHERE username = ?')
   ->execute([$new_password, 'admin']);
echo "Senha alterada com sucesso!";
?>
```

Ou edite o arquivo `includes/config.php` e procure pela função `initializeDatabase()`.

### 3. Adicionar Primeira Pessoa

1. Acesse o Admin
2. Clique em "Gerenciar Pessoas"
3. Clique em "Adicionar Pessoa"
4. Preencha os dados:
   - Nome (obrigatório)
   - Idade
   - Descrição
   - Data de desaparecimento
   - Local
   - Foto (opcional)
5. Clique em "Salvar"

### 4. Testar Página Pública

1. Acesse: `http://seu-dominio/`
2. Você verá o card da pessoa adicionada
3. Clique em "Quero Ajudar"
4. Preencha o formulário de contato
5. Clique em "Enviar Informações"

## 🐛 Troubleshooting

### Erro: "Banco de dados não encontrado"
- Verifique se a pasta `database/` tem permissão de escrita
- Execute: `chmod 777 database/`

### Erro: "Não consigo fazer upload de fotos"
- Verifique permissões da pasta `assets/images/`
- Execute: `chmod 777 assets/images/`

### Erro: "Sessão não funciona"
- Verifique se o PHP tem permissão de escrita em `/tmp`
- Verifique se `session.save_path` está configurado corretamente em `php.ini`

### Erro: "Página em branco"
- Verifique os logs do servidor web
- Ative o modo de debug em `includes/config.php`
- Teste com: `php -l public/index.php`

## 🔒 Segurança

### Recomendações

1. **Altere a senha padrão** imediatamente
2. **Use HTTPS** em produção
3. **Faça backup regular** do banco de dados
4. **Restrinja acesso** a `/admin` por IP se possível
5. **Mantenha PHP atualizado**
6. **Desabilite listagem de diretórios**

### Arquivo .htaccess (Apache)

Já incluído no projeto. Bloqueia acesso a:
- Arquivos de configuração
- Banco de dados
- Diretório `includes/`

### Nginx

Use a configuração fornecida em `nginx.conf` que já inclui:
- Bloqueio de acesso a arquivos sensíveis
- Cache de arquivos estáticos
- Limite de upload (10MB)

## 📊 Banco de Dados

### Tabelas

**admins**
- `id`: ID único
- `username`: Nome de usuário
- `password`: Senha (hash bcrypt)
- `created_at`: Data de criação

**pessoas_desaparecidas**
- `id`: ID único
- `nome`: Nome da pessoa
- `idade`: Idade
- `descricao`: Descrição
- `foto_path`: Caminho da foto
- `data_desaparecimento`: Data
- `local_desaparecimento`: Local
- `status`: 'ativo' ou 'inativo'
- `created_at`: Data de criação
- `updated_at`: Última atualização

**contatos**
- `id`: ID único
- `pessoa_id`: ID da pessoa (FK)
- `nome`: Nome do visitante
- `email`: Email
- `telefone`: Telefone
- `mensagem`: Mensagem
- `created_at`: Data de criação

## 🆘 Suporte

Para problemas ou dúvidas:

1. Verifique o arquivo `README.md`
2. Consulte os logs do servidor web
3. Teste com o script `test.php`
4. Verifique as permissões de arquivo/pasta

## 📝 Customização

### Alterar Cores

Edite os arquivos:
- `public/index.php` (linha ~80)
- `admin/login.php` (linha ~30)
- `admin/index.php` (linha ~30)
- `admin/pessoas.php` (linha ~30)
- `admin/contatos.php` (linha ~30)

Procure por:
```css
background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
```

### Adicionar Campos

1. Edite `includes/config.php`
2. Modifique a tabela `pessoas_desaparecidas`
3. Atualize `includes/functions.php`
4. Atualize os formulários em `admin/pessoas.php`

### Integrar com Email

Adicione em `includes/functions.php`:

```php
function enviarEmailContato($email, $assunto, $mensagem) {
    mail($email, $assunto, $mensagem);
}
```

## 📱 Responsividade

O sistema é totalmente responsivo:
- ✓ Desktop (1920px+)
- ✓ Tablet (768px - 1024px)
- ✓ Mobile (< 768px)

## 🎓 Tecnologias

- PHP 7.4+
- SQLite
- Bootstrap 5
- Tailwind CSS 4
- Font Awesome 6
- JavaScript Vanilla

## 📄 Licença

Este projeto é fornecido como está, sem garantias.

---

**Desenvolvido com ❤️ para ajudar a encontrar pessoas desaparecidas.**
