<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth.php';

requireAdminLogin();

// DB
$db = getDB();

// Buscar total de pessoas
$total_pessoas = $db->query("SELECT COUNT(*) AS total FROM pessoas")->fetch(PDO::FETCH_ASSOC)['total'];

// Buscar total de contatos
$total_contatos = $db->query("SELECT COUNT(*) AS total FROM contatos")->fetch(PDO::FETCH_ASSOC)['total'];

// Buscar últimas 5 pessoas cadastradas
$stmt = $db->query("SELECT * FROM pessoas ORDER BY id DESC LIMIT 5");
$ultimas_pessoas = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Pessoas Desaparecidas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .sidebar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: white;
            padding: 20px;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px 15px;
            margin: 5px 0;
            border-radius: 5px;
            transition: 0.3s;
        }
        .sidebar a:hover {
            background: rgba(255, 255, 255, 0.2);
        }
        .sidebar a.active {
            background: rgba(255, 255, 255, 0.3);
            font-weight: bold;
        }
        .main-content {
            padding: 30px;
        }
        .card {
            border: none;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 15px 20px;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
        }
        .stat-card {
            background: white;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        .stat-card h3 {
            color: #667eea;
            font-size: 2.5rem;
            margin: 10px 0;
        }
        .stat-card p {
            color: #666;
            margin: 0;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            
            <!-- Sidebar -->
            <div class="col-md-3 sidebar">
                <h3 class="mb-4"><i class="fas fa-shield-alt"></i> Admin Panel</h3>

                <a href="/admin/index.php" class="active"><i class="fas fa-home"></i> Dashboard</a>
                <a href="/admin/pessoas.php"><i class="fas fa-users"></i> Gerenciar Pessoas</a>
                <a href="/admin/contatos.php"><i class="fas fa-envelope"></i> Contatos Recebidos</a>

                <hr style="border-color: rgba(255, 255, 255, 0.2);">

                <a href="/admin/logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 main-content">

                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1>Dashboard</h1>
                    <span class="text-muted">Bem-vindo, <?php echo sanitize($_SESSION['admin_username']); ?>!</span>
                </div>
                
                <!-- Stats -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="stat-card">
                            <i class="fas fa-users" style="font-size: 2.5rem; color: #667eea;"></i>
                            <h3><?php echo $total_pessoas; ?></h3>
                            <p>Pessoas Desaparecidas</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="stat-card">
                            <i class="fas fa-envelope" style="font-size: 2.5rem; color: #764ba2;"></i>
                            <h3><?php echo $total_contatos; ?></h3>
                            <p>Contatos Recebidos</p>
                        </div>
                    </div>
                </div>
                
                <!-- Quick Actions -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Ações Rápidas</h5>
                    </div>
                    <div class="card-body">
                        <a href="/admin/pessoas.php?action=create" class="btn btn-primary me-2">
                            <i class="fas fa-plus"></i> Adicionar Pessoa
                        </a>
                        <a href="/admin/contatos.php" class="btn btn-secondary">
                            <i class="fas fa-inbox"></i> Ver Contatos
                        </a>
                    </div>
                </div>
                
                <!-- Recent Pessoas -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Pessoas Adicionadas Recentemente</h5>
                    </div>
                    <div class="card-body">

                        <?php if (empty($ultimas_pessoas)): ?>
                            <p class="text-muted">Nenhuma pessoa cadastrada ainda.</p>
                        <?php else: ?>

                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Nome</th>
                                        <th>Idade</th>
                                        <th>Data Desaparecimento</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($ultimas_pessoas as $pessoa): ?>
                                    <tr>
                                        <td><?php echo sanitize($pessoa['nome']); ?></td>
                                        <td><?php echo $pessoa['idade'] ?: 'N/A'; ?></td>
                                        <td><?php echo formatDate($pessoa['data_desaparecimento']); ?></td>
                                        <td>
                                            <a href="/admin/pessoas.php?action=edit&id=<?php echo $pessoa['id']; ?>" class="btn btn-sm btn-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="/admin/pessoas.php?action=delete&id=<?php echo $pessoa['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Tem certeza?')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                        <?php endif; ?>

                    </div>
                </div>
                
            </div>
        </div>
    </div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
