<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';

requireAdminLogin();

$action = $_GET['action'] ?? 'list';
$pessoa = null;
$error = '';
$success = '';

// Processar ações
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = sanitize($_POST['nome'] ?? '');
    $idade = intval($_POST['idade'] ?? 0);
    $descricao = sanitize($_POST['descricao'] ?? '');
    $data_desaparecimento = $_POST['data_desaparecimento'] ?? '';
    $local_desaparecimento = sanitize($_POST['local_desaparecimento'] ?? '');
    
    $foto_path = null;
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
        $foto_path = uploadFoto($_FILES['foto']);
    }
    
    if ($action === 'create') {
        if (createPessoa($nome, $idade, $descricao, $foto_path, $data_desaparecimento, $local_desaparecimento)) {
            $success = 'Pessoa adicionada com sucesso!';
            $action = 'list';
        } else {
            $error = 'Erro ao adicionar pessoa.';
        }
    } elseif ($action === 'edit') {
        $id = intval($_GET['id'] ?? 0);
        $pessoa_existente = getPessoaById($id);
        
        if ($pessoa_existente) {
            $foto_path = $foto_path ?? $pessoa_existente['foto_path'];
            if (updatePessoa($id, $nome, $idade, $descricao, $foto_path, $data_desaparecimento, $local_desaparecimento)) {
                $success = 'Pessoa atualizada com sucesso!';
                $action = 'list';
            } else {
                $error = 'Erro ao atualizar pessoa.';
            }
        }
    }
}

// Ações GET
if ($action === 'delete') {
    $id = intval($_GET['id'] ?? 0);
    if (deletePessoa($id)) {
        $success = 'Pessoa deletada com sucesso!';
        $action = 'list';
    } else {
        $error = 'Erro ao deletar pessoa.';
    }
}

if ($action === 'edit') {
    $id = intval($_GET['id'] ?? 0);
    $pessoa = getPessoaById($id);
    if (!$pessoa) {
        $error = 'Pessoa não encontrada.';
        $action = 'list';
    }
}

$pessoas = getAllPessoas();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Pessoas - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .sidebar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: white;
            padding: 20px;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px 15px;
            margin: 5px 0;
            border-radius: 5px;
            transition: 0.3s;
        }
        .sidebar a:hover {
            background: rgba(255, 255, 255, 0.2);
        }
        .sidebar a.active {
            background: rgba(255, 255, 255, 0.3);
            font-weight: bold;
        }
        .main-content {
            padding: 30px;
        }
        .card {
            border: none;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 15px 20px;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .preview-image {
            max-width: 200px;
            max-height: 200px;
            margin-top: 10px;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 sidebar">
                <h3 class="mb-4">
                    <i class="fas fa-shield-alt"></i> Admin Panel
                </h3>
                <a href="/admin/index.php">
                    <i class="fas fa-home"></i> Dashboard
                </a>
                <a href="/admin/pessoas.php" class="active">
                    <i class="fas fa-users"></i> Gerenciar Pessoas
                </a>
                <a href="/admin/contatos.php">
                    <i class="fas fa-envelope"></i> Contatos Recebidos
                </a>
                <hr style="border-color: rgba(255, 255, 255, 0.2);">
                <a href="/admin/logout.php">
                    <i class="fas fa-sign-out-alt"></i> Sair
                </a>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 main-content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1>Gerenciar Pessoas Desaparecidas</h1>
                </div>
                
                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?php echo $error; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if ($success): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo $success; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if ($action === 'list'): ?>
                    <!-- Lista de Pessoas -->
                    <div class="mb-3">
                        <a href="/admin/pessoas.php?action=create" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Adicionar Pessoa
                        </a>
                    </div>
                    
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Pessoas Cadastradas</h5>
                        </div>
                        <div class="card-body">
                            <?php if (empty($pessoas)): ?>
                                <p class="text-muted">Nenhuma pessoa cadastrada ainda.</p>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Foto</th>
                                                <th>Nome</th>
                                                <th>Idade</th>
                                                <th>Data Desaparecimento</th>
                                                <th>Local</th>
                                                <th>Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($pessoas as $p): ?>
                                                <tr>
                                                    <td>
                                                        <?php if ($p['foto_path']): ?>
                                                            <img src="<?php echo $p['foto_path']; ?>" alt="Foto" style="width: 50px; height: 50px; object-fit: cover; border-radius: 5px;">
                                                        <?php else: ?>
                                                            <span class="text-muted">Sem foto</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo sanitize($p['nome']); ?></td>
                                                    <td><?php echo $p['idade'] ?? 'N/A'; ?></td>
                                                    <td><?php echo formatDate($p['data_desaparecimento']); ?></td>
                                                    <td><?php echo sanitize($p['local_desaparecimento']); ?></td>
                                                    <td>
                                                        <a href="/admin/pessoas.php?action=edit&id=<?php echo $p['id']; ?>" class="btn btn-sm btn-warning">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        <a href="/admin/pessoas.php?action=delete&id=<?php echo $p['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Tem certeza que deseja deletar?')">
                                                            <i class="fas fa-trash"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                
                <?php elseif ($action === 'create' || $action === 'edit'): ?>
                    <!-- Formulário de Criação/Edição -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <?php echo $action === 'create' ? 'Adicionar Nova Pessoa' : 'Editar Pessoa'; ?>
                            </h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" enctype="multipart/form-data">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="nome" class="form-label">Nome *</label>
                                        <input type="text" class="form-control" id="nome" name="nome" required value="<?php echo $pessoa['nome'] ?? ''; ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="idade" class="form-label">Idade</label>
                                        <input type="number" class="form-control" id="idade" name="idade" value="<?php echo $pessoa['idade'] ?? ''; ?>">
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="descricao" class="form-label">Descrição</label>
                                    <textarea class="form-control" id="descricao" name="descricao" rows="4"><?php echo $pessoa['descricao'] ?? ''; ?></textarea>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="data_desaparecimento" class="form-label">Data Desaparecimento</label>
                                        <input type="date" class="form-control" id="data_desaparecimento" name="data_desaparecimento" value="<?php echo $pessoa['data_desaparecimento'] ?? ''; ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="local_desaparecimento" class="form-label">Local Desaparecimento</label>
                                        <input type="text" class="form-control" id="local_desaparecimento" name="local_desaparecimento" value="<?php echo $pessoa['local_desaparecimento'] ?? ''; ?>">
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="foto" class="form-label">Foto</label>
                                    <input type="file" class="form-control" id="foto" name="foto" accept="image/*">
                                    <?php if ($pessoa && $pessoa['foto_path']): ?>
                                        <div class="mt-2">
                                            <p class="text-muted">Foto atual:</p>
                                            <img src="<?php echo $pessoa['foto_path']; ?>" alt="Foto" class="preview-image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save"></i> Salvar
                                    </button>
                                    <a href="/admin/pessoas.php" class="btn btn-secondary">
                                        <i class="fas fa-times"></i> Cancelar
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
