<?php

// Obter todas as pessoas desaparecidas
function getAllPessoas() {
    $db = getDB();
    $stmt = $db->query('SELECT * FROM pessoas_desaparecidas WHERE status = "ativo" ORDER BY created_at DESC');
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Obter pessoa por ID
function getPessoaById($id) {
    $db = getDB();
    $stmt = $db->prepare('SELECT * FROM pessoas_desaparecidas WHERE id = ?');
    $stmt->execute([$id]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

// Criar nova pessoa desaparecida
function createPessoa($nome, $idade, $descricao, $foto_path, $data_desaparecimento, $local_desaparecimento) {
    $db = getDB();
    $stmt = $db->prepare('
        INSERT INTO pessoas_desaparecidas (nome, idade, descricao, foto_path, data_desaparecimento, local_desaparecimento)
        VALUES (?, ?, ?, ?, ?, ?)
    ');
    return $stmt->execute([$nome, $idade, $descricao, $foto_path, $data_desaparecimento, $local_desaparecimento]);
}

// Atualizar pessoa desaparecida
function updatePessoa($id, $nome, $idade, $descricao, $foto_path, $data_desaparecimento, $local_desaparecimento) {
    $db = getDB();
    $stmt = $db->prepare('
        UPDATE pessoas_desaparecidas 
        SET nome = ?, idade = ?, descricao = ?, foto_path = ?, data_desaparecimento = ?, local_desaparecimento = ?, updated_at = CURRENT_TIMESTAMP
        WHERE id = ?
    ');
    return $stmt->execute([$nome, $idade, $descricao, $foto_path, $data_desaparecimento, $local_desaparecimento, $id]);
}

// Deletar pessoa desaparecida
function deletePessoa($id) {
    $db = getDB();
    $stmt = $db->prepare('DELETE FROM pessoas_desaparecidas WHERE id = ?');
    return $stmt->execute([$id]);
}

// Criar contato/informação
function createContato($pessoa_id, $nome, $email, $telefone, $mensagem) {
    $db = getDB();
    $stmt = $db->prepare('
        INSERT INTO contatos (pessoa_id, nome, email, telefone, mensagem)
        VALUES (?, ?, ?, ?, ?)
    ');
    return $stmt->execute([$pessoa_id, $nome, $email, $telefone, $mensagem]);
}

// Obter contatos de uma pessoa
function getContatosByPessoa($pessoa_id) {
    $db = getDB();
    $stmt = $db->prepare('SELECT * FROM contatos WHERE pessoa_id = ? ORDER BY created_at DESC');
    $stmt->execute([$pessoa_id]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Upload de foto
function uploadFoto($file) {
    if (!isset($file) || $file['error'] !== UPLOAD_ERR_OK) {
        return null;
    }
    
    $upload_dir = __DIR__ . '/../assets/images/';
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }
    
    $filename = uniqid() . '_' . basename($file['name']);
    $filepath = $upload_dir . $filename;
    
    if (move_uploaded_file($file['tmp_name'], $filepath)) {
        return '/assets/images/' . $filename;
    }
    
    return null;
}

// Sanitizar entrada
function sanitize($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

// Formatar data
function formatDate($date) {
    if (empty($date)) return 'N/A';
    return date('d/m/Y', strtotime($date));
}
?>
